/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.variable;

import com.sun.electric.database.EObjectInputStream;
import com.sun.electric.database.EObjectOutputStream;
import com.sun.electric.database.id.IdReader;
import com.sun.electric.database.id.IdWriter;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.lang.EvalJavaBsh;
import com.sun.electric.tool.lang.EvalSpice;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.collections.ArrayIterator;
import java.io.IOException;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CodeExpression
implements Serializable {
    private static final int VCODE1 = 32;
    private static final int VCODE2 = 0x20000000;
    private static final int VSPICE = 32;
    private static final int VTCL = 0x20000000;
    private static final int VJAVA = 0x20000020;
    private static final HashMap<String, CodeExpression> javaExpressions = new HashMap();
    private static final HashMap<String, CodeExpression> spiceExpressions = new HashMap();
    private static final HashMap<String, CodeExpression> tclExpressions = new HashMap();
    private static long numValueOfs;
    private static final Pattern pPat;
    private final Code code;
    private final String expr;
    private final Set<Variable.Key> depends;
    private final Expr exprTree;
    private final boolean dependsOnEverything;
    private final EvalSpice.ParseException parseException;
    private final String spiceText;
    private final String spiceTextPar;

    private CodeExpression(String expr, Code code) {
        this.code = code;
        this.expr = expr;
        TreeSet<Variable.Key> varKeys = new TreeSet<Variable.Key>();
        String replacedExpr = EvalJavaBsh.replace(expr);
        Matcher pMat = pPat.matcher(replacedExpr);
        while (pMat.find()) {
            String varName = pMat.group(1);
            varKeys.add(Variable.newKey(varName));
        }
        this.depends = Collections.unmodifiableSet(varKeys);
        String patchedExpr = expr.replace("((Number)@X).doubleValue()", "@X");
        Expr exprTree = null;
        EvalSpice.ParseException parseException = null;
        try {
            switch (code) {
                case JAVA: {
                    exprTree = CodeExpression.parse(patchedExpr, true);
                    break;
                }
                case SPICE: {
                    exprTree = CodeExpression.parse(patchedExpr, false);
                    break;
                }
                default: {
                    throw new EvalSpice.ParseException("Unsupported code " + (Object)((Object)code));
                }
            }
        }
        catch (EvalSpice.ParseException e) {
            parseException = e;
        }
        this.exprTree = exprTree;
        this.parseException = parseException;
        if (parseException != null) {
            this.dependsOnEverything = true;
            this.spiceTextPar = this.spiceText = parseException.getMessage();
        } else {
            this.dependsOnEverything = exprTree.dependsOnEverything();
            StringBuilder sb = new StringBuilder();
            exprTree.appendText(sb);
            this.spiceText = new String(sb);
            sb.setLength(0);
            exprTree.appendText(sb, 1);
            this.spiceTextPar = new String(sb);
        }
    }

    private Object writeReplace() {
        return new CodeExpressionKey(this);
    }

    public static synchronized CodeExpression valueOf(String expression, Code code) {
        HashMap<String, CodeExpression> allExpressions;
        ++numValueOfs;
        switch (code) {
            case JAVA: {
                allExpressions = javaExpressions;
                break;
            }
            case SPICE: {
                allExpressions = spiceExpressions;
                break;
            }
            case TCL: {
                allExpressions = tclExpressions;
                break;
            }
            default: {
                throw new IllegalArgumentException("code");
            }
        }
        CodeExpression ce = allExpressions.get(expression);
        if (ce == null) {
            ce = new CodeExpression(expression, code);
            allExpressions.put(expression, ce);
        }
        return ce;
    }

    public Code getCode() {
        return this.code;
    }

    public boolean isJava() {
        return this.code == Code.JAVA;
    }

    public String getExpr() {
        return this.expr;
    }

    public Set<Variable.Key> dependsOn() {
        return this.depends;
    }

    public EvalSpice.ParseException getParseException() {
        return this.parseException;
    }

    public String getSpiceText() {
        return this.spiceText;
    }

    public String getHSpiceText(boolean inPar) {
        return this.dependsOnEverything ? null : (inPar ? this.spiceTextPar : this.spiceText);
    }

    public String getVerilogText() {
        return this.spiceText;
    }

    public Object eval() {
        if (this.parseException != null) {
            return this.parseException.getMessage();
        }
        return this.exprTree.eval(new EvalContext());
    }

    public int hashCode() {
        return this.expr.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof CodeExpression) {
            CodeExpression that = (CodeExpression)o;
            return this.code == that.code && this.expr.equals(that.expr);
        }
        return false;
    }

    public String toString() {
        return this.expr;
    }

    public void write(IdWriter writer) throws IOException {
        writer.writeString(this.expr);
        writer.writeByte((byte)this.code.ordinal());
    }

    public static CodeExpression read(IdReader reader) throws IOException {
        String expr = reader.readString();
        Code code = Code.getByOrdinal(reader.readByte());
        return CodeExpression.valueOf(expr, code);
    }

    void check() {
        assert (this.expr != null);
        assert (this.code != null && this.code != Code.NONE);
    }

    public static void printStatistics(boolean verbose) {
        System.out.println(javaExpressions.size() + spiceExpressions.size() + tclExpressions.size() + " CodeExpressions after " + numValueOfs + " valueOf calls");
        if (!verbose) {
            return;
        }
        System.out.println(javaExpressions.size() + " java strings");
        for (CodeExpression ce : new TreeMap<String, CodeExpression>(javaExpressions).values()) {
            CodeExpression.printCE(ce);
        }
        System.out.println(spiceExpressions.size() + " spice strings");
        for (CodeExpression ce : new TreeMap<String, CodeExpression>(spiceExpressions).values()) {
            CodeExpression.printCE(ce);
        }
        System.out.println(tclExpressions.size() + " tcl strings");
        for (CodeExpression ce : new TreeMap<String, CodeExpression>(tclExpressions).values()) {
            CodeExpression.printCE(ce);
        }
    }

    private static void printCE(CodeExpression ce) {
        System.out.print("\"" + ce.getExpr() + "\"\t");
        if (ce.dependsOnEverything) {
            System.out.print(" ALL");
        }
        for (Variable.Key varKey : ce.dependsOn()) {
            System.out.print(" " + varKey);
        }
        if (ce.parseException != null) {
            System.out.print(" ? " + ce.parseException.getMessage());
        } else {
            System.out.print(" -> \"" + ce.spiceText + "\"");
        }
        System.out.println();
    }

    static Expr parse(String expr, boolean isJava) throws EvalSpice.ParseException {
        return new ParseSpice_(expr, isJava).parse();
    }

    static {
        pPat = Pattern.compile("P\\(\"(\\w+)\"\\)");
    }

    static class ParseSpice_ {
        private String expr;
        private boolean isJava;
        private StringReader reader;
        private StreamTokenizer tokenizer;
        EvalSpice.Op op;

        private ParseSpice_(String expr, boolean isJava) {
            this.expr = expr;
            this.isJava = isJava;
            this.reader = new StringReader(expr);
            this.tokenizer = new StreamTokenizer(this.reader);
            this.tokenizer.parseNumbers();
            this.tokenizer.ordinaryChar(40);
            this.tokenizer.ordinaryChar(41);
            this.tokenizer.ordinaryChar(42);
            this.tokenizer.ordinaryChar(47);
            this.tokenizer.ordinaryChar(43);
            this.tokenizer.ordinaryChar(45);
            this.tokenizer.ordinaryChar(60);
            this.tokenizer.ordinaryChar(61);
            this.tokenizer.ordinaryChar(62);
            this.tokenizer.ordinaryChar(33);
            this.tokenizer.ordinaryChar(63);
            this.tokenizer.ordinaryChar(58);
            this.tokenizer.ordinaryChar(64);
            this.tokenizer.quoteChar(34);
            this.tokenizer.wordChars(95, 95);
        }

        private Expr parse() throws EvalSpice.ParseException {
            try {
                this.nextToken();
                Expr expr = this.evalEq();
                assert (this.op == null);
                switch (this.tokenizer.ttype) {
                    case -1: {
                        return expr;
                    }
                    case 10: {
                        throw new EvalSpice.ParseException("Multiline expression");
                    }
                    case -3: 
                    case -2: 
                    case 40: {
                        throw new EvalSpice.ParseException("Two operands with no operator");
                    }
                }
                throw new EvalSpice.ParseException("Unexpected character " + (char)this.tokenizer.ttype);
            }
            catch (IOException e) {
                throw new EvalSpice.ParseException(e.getMessage());
            }
            catch (EvalSpice.ParseException e) {
                try {
                    long left = this.reader.skip(Long.MAX_VALUE);
                    int pos = this.expr.length() - (int)left;
                    throw new EvalSpice.ParseException(this.expr.substring(0, pos) + "<" + e.getMessage() + ">" + this.expr.substring(pos));
                }
                catch (IOException iOException) {
                    throw new AssertionError();
                }
            }
        }

        private Expr evalEq() throws IOException, EvalSpice.ParseException {
            return this.evalEq(Expr.MAX_PRECEDENCE);
        }

        private Expr evalEq(int outerPrecedence) throws IOException, EvalSpice.ParseException {
            Expr e;
            boolean unaryMinus = false;
            if (this.op == EvalSpice.Op.MINUS) {
                unaryMinus = true;
                this.nextToken();
            }
            if (this.tokenizer.ttype == 40) {
                this.nextToken();
                e = this.evalEq();
                this.expect(41);
            } else if (this.tokenizer.ttype == -2) {
                e = this.parseNumber();
            } else if (this.tokenizer.ttype == -3) {
                e = this.parseWord();
            } else if (this.tokenizer.ttype == 64) {
                if (this.nextToken() != -3) {
                    throw new EvalSpice.ParseException("Bad name after @");
                }
                e = new VarExpr(Variable.newKey("ATTR_" + this.tokenizer.sval));
                this.nextToken();
            } else {
                if (this.op != null) {
                    throw new EvalSpice.ParseException("Operator " + this.op + " with no left hand operand");
                }
                throw new EvalSpice.ParseException("Expected identifier");
            }
            if (unaryMinus) {
                e = new UnaryOpExpr(e);
            }
            while (this.op != null && outerPrecedence >= this.op.precedence) {
                if (this.op == EvalSpice.Op.COND) {
                    this.nextToken();
                    Expr thenE = this.evalEq(Expr.MAX_PRECEDENCE - 1);
                    this.expect(58);
                    Expr elseE = this.evalEq();
                    return new IfThenElseExpr(e, thenE, elseE);
                }
                EvalSpice.Op myOp = this.op;
                assert (outerPrecedence >= myOp.precedence);
                this.nextToken();
                Expr e2 = this.evalEq(myOp.precedence - 1);
                e = new BinaryOpExpr(e, myOp, e2);
            }
            return e;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private ConstExpr parseNumber() throws IOException, EvalSpice.ParseException {
            assert (this.tokenizer.ttype == -2);
            double val = this.tokenizer.nval;
            this.tokenizer.ordinaryChar(101);
            this.tokenizer.ordinaryChar(69);
            int tt = this.tokenizer.nextToken();
            if (tt == 101 || tt == 69) {
                tt = this.tokenizer.nextToken();
                boolean minus2 = false;
                if (tt == 45) {
                    minus2 = true;
                    tt = this.tokenizer.nextToken();
                }
                if (tt != -2) throw new EvalSpice.ParseException("Invalid token");
                double exp = this.tokenizer.nval;
                if (minus2) {
                    exp = -1.0 * exp;
                }
                val *= Math.pow(10.0, exp);
            } else if (tt == -3) {
                if (this.tokenizer.sval.equalsIgnoreCase("g")) {
                    val *= 1.0E9;
                } else if (this.tokenizer.sval.equalsIgnoreCase("meg")) {
                    val *= 1000000.0;
                } else if (this.tokenizer.sval.equalsIgnoreCase("k")) {
                    val *= 1000.0;
                } else if (this.tokenizer.sval.equalsIgnoreCase("m")) {
                    val *= 0.001;
                } else if (this.tokenizer.sval.equalsIgnoreCase("u")) {
                    val *= 1.0E-6;
                } else if (this.tokenizer.sval.equalsIgnoreCase("n")) {
                    val *= 1.0E-9;
                } else if (this.tokenizer.sval.equalsIgnoreCase("p")) {
                    val *= 1.0E-12;
                } else {
                    if (!this.tokenizer.sval.equalsIgnoreCase("f")) throw new EvalSpice.ParseException("Invalid token");
                    val *= 1.0E-15;
                }
            } else {
                this.tokenizer.pushBack();
            }
            this.tokenizer.wordChars(101, 101);
            this.tokenizer.wordChars(69, 69);
            this.nextToken();
            return new ConstExpr(new Double(val));
        }

        private Expr parseWord() throws IOException, EvalSpice.ParseException {
            assert (this.tokenizer.ttype == -3);
            String id = this.tokenizer.sval;
            for (UnaryFunExpr.Fun fun : (UnaryFunExpr.Fun[])UnaryFunExpr.Fun.class.getEnumConstants()) {
                if (!id.equalsIgnoreCase(fun.toString()) && !id.equals("Math." + fun.toString())) continue;
                this.nextToken();
                this.expect(40);
                Expr arg = this.evalEq();
                this.expect(41);
                return new UnaryFunExpr(fun, arg);
            }
            for (Enum enum_ : (BinaryFunExpr.Fun[])BinaryFunExpr.Fun.class.getEnumConstants()) {
                if (!id.equalsIgnoreCase(enum_.toString()) && !id.equals("Math." + enum_.toString())) continue;
                this.nextToken();
                this.expect(40);
                Expr arg1 = this.evalEq();
                this.expect(44);
                Expr arg2 = this.evalEq();
                this.expect(41);
                return new BinaryFunExpr((BinaryFunExpr.Fun)enum_, arg1, arg2);
            }
            if (id.equals("P")) {
                this.nextToken();
                this.expect(40);
                if (this.tokenizer.ttype != 34) {
                    throw new EvalSpice.ParseException("Bad name after @");
                }
                Variable.Key varKey = Variable.newKey(this.tokenizer.sval);
                this.nextToken();
                this.expect(41);
                return new VarExpr(varKey);
            }
            if (this.isJava && id.equals("LE.getdrive")) {
                this.nextToken();
                this.expect(40);
                this.expect(41);
                return new GetDriveExpr();
            }
            if (this.isJava && id.equals("LE.subdrive")) {
                this.nextToken();
                this.expect(40);
                if (this.tokenizer.ttype != 34) {
                    throw new EvalSpice.ParseException("Bad name after subdrive");
                }
                String instName = this.tokenizer.sval;
                this.nextToken();
                this.expect(44);
                if (this.tokenizer.ttype != 34) {
                    throw new EvalSpice.ParseException("Bad name after subdrive");
                }
                String varName = this.tokenizer.sval;
                this.nextToken();
                this.expect(41);
                return new SubDriveExpr(instName, varName);
            }
            Variable.Key attrKey = Variable.newKey("ATTR_" + this.tokenizer.sval);
            this.nextToken();
            return new VarExpr(attrKey);
        }

        private void expect(int token2) throws IOException, EvalSpice.ParseException {
            if (this.tokenizer.ttype != token2) {
                throw new EvalSpice.ParseException("Expected token " + (char)token2);
            }
            this.nextToken();
        }

        private int nextToken() throws IOException, EvalSpice.ParseException {
            switch (this.tokenizer.nextToken()) {
                case 42: {
                    this.op = EvalSpice.Op.MULT;
                    break;
                }
                case 47: {
                    this.op = EvalSpice.Op.DIV;
                    break;
                }
                case 43: {
                    this.op = EvalSpice.Op.PLUS;
                    break;
                }
                case 45: {
                    this.op = EvalSpice.Op.MINUS;
                    break;
                }
                case 60: {
                    this.op = EvalSpice.Op.LT;
                    if (this.tokenizer.nextToken() == 61) {
                        this.op = EvalSpice.Op.LTOE;
                        break;
                    }
                    this.tokenizer.pushBack();
                    break;
                }
                case 62: {
                    this.op = EvalSpice.Op.GT;
                    if (this.tokenizer.nextToken() == 61) {
                        this.op = EvalSpice.Op.GTOE;
                        break;
                    }
                    this.tokenizer.pushBack();
                    break;
                }
                case 61: {
                    this.op = EvalSpice.Op.EQ;
                    if (this.tokenizer.nextToken() == 61) break;
                    throw new EvalSpice.ParseException("Expected token ==");
                }
                case 33: {
                    this.op = EvalSpice.Op.NE;
                    if (this.tokenizer.nextToken() == 61) break;
                    throw new EvalSpice.ParseException("Expected token !=");
                }
                case 63: {
                    this.op = EvalSpice.Op.COND;
                    break;
                }
                case 10: {
                    throw new EvalSpice.ParseException("Multiline expression");
                }
                case -3: 
                case -2: 
                case -1: 
                case 34: 
                case 40: 
                case 41: 
                case 44: 
                case 58: 
                case 64: {
                    this.op = null;
                    break;
                }
                default: {
                    throw new EvalSpice.ParseException("Illegal character " + (char)this.tokenizer.ttype);
                }
            }
            return this.tokenizer.ttype;
        }
    }

    private static class IfThenElseExpr
    extends Expr {
        private static final int precedence = MAX_PRECEDENCE;
        final Expr condS;
        final Expr thenS;
        final Expr elseS;

        IfThenElseExpr(Expr condS, Expr thenS, Expr elseS) {
            this.condS = condS;
            this.thenS = thenS;
            this.elseS = elseS;
        }

        @Override
        int numSubExprs() {
            return 3;
        }

        @Override
        Expr getSubExpr(int i) {
            if (i == 0) {
                return this.condS;
            }
            if (i == 1) {
                return this.thenS;
            }
            if (i == 2) {
                return this.elseS;
            }
            return super.getSubExpr(i);
        }

        @Override
        void appendText(StringBuilder sb) {
            this.condS.appendText(sb, precedence - 1);
            sb.append('?');
            this.thenS.appendText(sb, precedence - 1);
            sb.append(':');
            this.elseS.appendText(sb, precedence);
        }

        @Override
        int precedence() {
            return MAX_PRECEDENCE;
        }

        @Override
        Object eval(EvalContext context) {
            boolean condV = IfThenElseExpr.bool((Double)this.condS.eval(context));
            double v = (Double)(condV ? this.thenS : this.elseS).eval(context);
            return v;
        }
    }

    private static class BinaryFunExpr
    extends BinaryExpr {
        private final Fun fun;

        BinaryFunExpr(Fun fun, Expr ls, Expr rs) {
            super(ls, rs);
            this.fun = fun;
        }

        @Override
        void appendText(StringBuilder sb) {
            sb.append((Object)this.fun);
            sb.append('(');
            this.ls.appendText(sb, MAX_PRECEDENCE);
            sb.append(',');
            this.rs.appendText(sb, MAX_PRECEDENCE);
            sb.append(')');
        }

        @Override
        double apply(double lv, double rv) {
            switch (this.fun) {
                case min: {
                    return Math.min(lv, rv);
                }
                case max: {
                    return Math.max(lv, rv);
                }
            }
            throw new AssertionError();
        }

        static enum Fun {
            min,
            max;

        }
    }

    private static class BinaryOpExpr
    extends BinaryExpr {
        private final EvalSpice.Op op;

        BinaryOpExpr(Expr ls, EvalSpice.Op op, Expr rs) {
            super(ls, rs);
            this.op = op;
        }

        @Override
        void appendText(StringBuilder sb) {
            this.ls.appendText(sb, this.op.precedence);
            sb.append(this.op.name);
            this.rs.appendText(sb, this.op.precedence - 1);
        }

        @Override
        int precedence() {
            return this.op.precedence;
        }

        @Override
        double apply(double lv, double rv) {
            if (this.op == EvalSpice.Op.MULT) {
                return lv * rv;
            }
            if (this.op == EvalSpice.Op.DIV) {
                return lv / rv;
            }
            if (this.op == EvalSpice.Op.PLUS) {
                return lv + rv;
            }
            if (this.op == EvalSpice.Op.MINUS) {
                return lv - rv;
            }
            if (this.op == EvalSpice.Op.LT) {
                return BinaryOpExpr.valueOf(lv < rv);
            }
            if (this.op == EvalSpice.Op.LTOE) {
                return BinaryOpExpr.valueOf(lv <= rv);
            }
            if (this.op == EvalSpice.Op.GT) {
                return BinaryOpExpr.valueOf(lv > rv);
            }
            if (this.op == EvalSpice.Op.GTOE) {
                return BinaryOpExpr.valueOf(lv >= rv);
            }
            if (this.op == EvalSpice.Op.EQ) {
                return BinaryOpExpr.valueOf(lv == rv);
            }
            if (this.op == EvalSpice.Op.NE) {
                return BinaryOpExpr.valueOf(lv != rv);
            }
            if (this.op == EvalSpice.Op.LAND) {
                return BinaryOpExpr.valueOf(BinaryOpExpr.bool(lv) && BinaryOpExpr.bool(rv));
            }
            if (this.op == EvalSpice.Op.LOR) {
                return BinaryOpExpr.valueOf(BinaryOpExpr.bool(lv) || BinaryOpExpr.bool(rv));
            }
            throw new AssertionError();
        }

        private static double valueOf(boolean b) {
            return b ? 1.0 : 0.0;
        }
    }

    private static abstract class BinaryExpr
    extends Expr {
        final Expr ls;
        final Expr rs;

        BinaryExpr(Expr ls, Expr rs) {
            this.ls = ls;
            this.rs = rs;
        }

        @Override
        int numSubExprs() {
            return 2;
        }

        @Override
        Expr getSubExpr(int i) {
            if (i == 0) {
                return this.ls;
            }
            if (i == 1) {
                return this.rs;
            }
            return super.getSubExpr(i);
        }

        @Override
        Object eval(EvalContext context) {
            double lv = (Double)this.ls.eval(context);
            double rv = (Double)this.rs.eval(context);
            return this.apply(lv, rv);
        }

        abstract double apply(double var1, double var3);
    }

    private static class UnaryFunExpr
    extends UnaryExpr {
        private final Fun fun;

        UnaryFunExpr(Fun fun, Expr s) {
            super(s);
            this.fun = fun;
        }

        @Override
        void appendText(StringBuilder sb) {
            sb.append((Object)this.fun);
            sb.append('(');
            this.s.appendText(sb, MAX_PRECEDENCE);
            sb.append(')');
        }

        @Override
        double apply(double v) {
            switch (this.fun) {
                case sin: {
                    return Math.sin(v);
                }
                case abs: {
                    return Math.abs(v);
                }
                case sqrt: {
                    return Math.sqrt(v);
                }
                case int_: {
                    return (int)v;
                }
            }
            throw new AssertionError();
        }

        static enum Fun {
            sin,
            abs,
            sqrt,
            int_;


            public String toString() {
                return this == int_ ? "int" : super.toString();
            }
        }
    }

    private static class UnaryOpExpr
    extends UnaryExpr {
        private static final String opName = EvalSpice.Op.MINUS.name;
        private static final int opPrecedence = 1;

        UnaryOpExpr(Expr s) {
            super(s);
        }

        @Override
        void appendText(StringBuilder sb) {
            sb.append(opName);
            this.s.appendText(sb, 1);
        }

        @Override
        int precedence() {
            return 1;
        }

        @Override
        double apply(double v) {
            return -v;
        }
    }

    private static abstract class UnaryExpr
    extends Expr {
        final Expr s;

        UnaryExpr(Expr s) {
            this.s = s;
        }

        @Override
        int numSubExprs() {
            return 1;
        }

        @Override
        Expr getSubExpr(int i) {
            if (i == 0) {
                return this.s;
            }
            return super.getSubExpr(i);
        }

        @Override
        Object eval(EvalContext context) {
            double v = ((Number)this.s.eval(context)).doubleValue();
            return this.apply(v);
        }

        abstract double apply(double var1);
    }

    private static class SubDriveExpr
    extends Expr {
        private final String instName;
        private final String varName;

        SubDriveExpr(String instName, String varName) {
            this.instName = instName;
            this.varName = varName;
        }

        @Override
        void appendText(StringBuilder sb) {
            sb.append("LE.subdrive(\"" + this.instName + "\",\"" + this.varName + "\")");
        }

        @Override
        boolean dependsOnEverything() {
            return true;
        }

        @Override
        Object eval(EvalContext context) {
            return context.subDrive(this.instName, this.varName);
        }
    }

    private static class GetDriveExpr
    extends Expr {
        GetDriveExpr() {
        }

        @Override
        void appendText(StringBuilder sb) {
            sb.append("LE.getdrive()");
        }

        @Override
        boolean dependsOnEverything() {
            return true;
        }

        @Override
        Object eval(EvalContext context) {
            return context.getDrive();
        }
    }

    private static class VarExpr
    extends Expr {
        private final Variable.Key varKey;

        VarExpr(Variable.Key varKey) {
            if (varKey == null) {
                throw new NullPointerException();
            }
            this.varKey = varKey;
        }

        @Override
        void appendText(StringBuilder sb) {
            String name = this.varKey.getName();
            if (name.startsWith("ATTR_")) {
                name = name.substring(5);
            }
            sb.append(name);
        }

        @Override
        Object eval(EvalContext context) {
            return context.get(this.varKey);
        }
    }

    private static class ConstExpr
    extends Expr {
        private final Object value;

        ConstExpr(Object value2) {
            this.value = value2;
        }

        @Override
        void appendText(StringBuilder sb) {
            String s = TextUtils.formatDoublePostFix((Double)this.value);
            sb.append(s);
        }

        @Override
        Object eval(EvalContext context) {
            return this.value;
        }
    }

    private static abstract class Expr {
        static final int MIN_PRECEDENCE = 1;
        static final int MAX_PRECEDENCE = EvalSpice.Op.COND.precedence;

        private Expr() {
        }

        int numSubExprs() {
            return 0;
        }

        Expr getSubExpr(int i) {
            throw new IndexOutOfBoundsException();
        }

        void appendText(StringBuilder sb, int outerPrecedence) {
            if (outerPrecedence < this.precedence()) {
                sb.append('(');
                this.appendText(sb);
                sb.append(')');
            } else {
                this.appendText(sb);
            }
        }

        abstract void appendText(StringBuilder var1);

        int precedence() {
            return 1;
        }

        boolean dependsOnEverything() {
            for (int i = 0; i < this.numSubExprs(); ++i) {
                if (!this.getSubExpr(i).dependsOnEverything()) continue;
                return true;
            }
            return false;
        }

        abstract Object eval(EvalContext var1);

        static boolean bool(double d) {
            return d != 0.0;
        }
    }

    private static class EvalContext {
        private EvalContext() {
        }

        private Object getDrive() {
            return null;
        }

        private Object subDrive(String instName, String varName) {
            return null;
        }

        private Object get(Variable.Key varKey) {
            return null;
        }
    }

    private static class CodeExpressionKey
    extends EObjectInputStream.Key<CodeExpression> {
        public CodeExpressionKey() {
        }

        private CodeExpressionKey(CodeExpression ce) {
            super(ce);
        }

        @Override
        public void writeExternal(EObjectOutputStream out, CodeExpression ce) throws IOException {
            out.writeUTF(ce.getExpr());
            out.writeByte(ce.getCode().ordinal());
        }

        @Override
        public CodeExpression readExternal(EObjectInputStream in) throws IOException, ClassNotFoundException {
            String expr = in.readUTF();
            Code code = Code.getByOrdinal(in.readByte());
            return CodeExpression.valueOf(expr, code);
        }
    }

    public static enum Code {
        JAVA("Java", 0x20000020),
        SPICE("Spice", 32),
        TCL("TCL (not avail.)", 0x20000000),
        NONE("Not Code", 0);

        private final String name;
        private final int cFlags;
        private static final Code[] allCodes;

        private Code(String name, int cFlags) {
            this.name = name;
            this.cFlags = cFlags;
        }

        public int getCFlags() {
            return this.cFlags;
        }

        public String toString() {
            return this.name;
        }

        public static Iterator<Code> getCodes() {
            return ArrayIterator.iterator(allCodes);
        }

        public static Code getByCBits(int cBits) {
            switch (cBits & 0x20000020) {
                case 0x20000020: {
                    return JAVA;
                }
                case 32: {
                    return SPICE;
                }
                case 0x20000000: {
                    return TCL;
                }
            }
            return NONE;
        }

        public static Code getByOrdinal(int ordinal) {
            return allCodes[ordinal];
        }

        static {
            allCodes = (Code[])Code.class.getEnumConstants();
        }
    }
}

