/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.drc;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.ErrorLogger;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class CalibreDrcErrors {
    private int scale;
    private String topCellName;
    private Cell topCell;
    private ErrorLogger logger;
    private BufferedReader in;
    private List<DrcRuleViolation> ruleViolations;
    private int lineno;
    private Map<Cell, String> mangledNames;
    private String type;
    private String filename;
    private boolean noPopupMessages;
    private static final String spaces = "[\\s\\t ]+";
    private Cell incell = null;

    public static int importErrors(String filename, Map<Cell, String> mangledNames, String type, boolean noPopupMessages) {
        BufferedReader in;
        try {
            FileReader reader = new FileReader(filename);
            in = new BufferedReader(reader);
        }
        catch (IOException e) {
            System.out.println("Error importing " + type + " Errors: " + e.getMessage());
            return -1;
        }
        if (in == null) {
            return -1;
        }
        CalibreDrcErrors errors = new CalibreDrcErrors(in, mangledNames, type, noPopupMessages);
        errors.filename = filename;
        if (!errors.readTop()) {
            return -1;
        }
        if (!errors.readRules()) {
            return -1;
        }
        return errors.done();
    }

    private CalibreDrcErrors(BufferedReader in, Map<Cell, String> mangledNames, String type, boolean noPopupMessages) {
        assert (in != null);
        this.in = in;
        this.lineno = 0;
        this.ruleViolations = new ArrayList<DrcRuleViolation>();
        this.mangledNames = mangledNames;
        this.type = type;
        this.noPopupMessages = noPopupMessages;
    }

    private boolean readTop() {
        String line;
        this.scale = 1000;
        try {
            line = this.readLine(true);
        }
        catch (IOException e) {
            System.out.println("Error reading first line of file: " + e.getMessage());
            return false;
        }
        if (line == null) {
            return false;
        }
        String[] parts = line.trim().split(spaces);
        if (parts.length == 1) {
            this.topCellName = parts[0];
        } else if (parts.length == 2) {
            this.topCellName = parts[0];
            try {
                this.scale = Integer.parseInt(parts[1]);
            }
            catch (NumberFormatException e) {
                System.out.println("Error converting precision '" + parts[1] + "' to a number, using default of " + this.scale);
                return false;
            }
        } else {
            System.out.println("Error on first line: Expected cell name and precision, or 'drc'");
            return false;
        }
        this.topCell = CalibreDrcErrors.getCell(this.topCellName, this.mangledNames);
        if (this.topCell == null) {
            System.out.println("Cannot find cell " + this.topCellName + " specified in error file, line number " + this.lineno + ", aborting");
            return false;
        }
        return true;
    }

    private boolean readRules() {
        try {
            DrcRuleViolation v;
            while ((v = this.readRule()) != null) {
                if (v.errors.size() == 0) continue;
                this.ruleViolations.add(v);
            }
        }
        catch (IOException e) {
            System.out.println("Error reading file: " + e.getMessage());
            return false;
        }
        return true;
    }

    private DrcRuleViolation readRule() throws IOException {
        DrcError drc;
        String ruleName = this.readLine(false);
        if (ruleName == null) {
            return null;
        }
        Header header = this.readHeader();
        if (header == null) {
            return null;
        }
        for (int i = 0; i < header.headerLength; ++i) {
            String s = this.readLine();
            if (s == null) {
                return null;
            }
            header.addHeaderLine(s);
        }
        if (header.comment.length() == 0) {
            header.comment.append(ruleName);
        }
        DrcRuleViolation v = new DrcRuleViolation(ruleName, header);
        this.incell = this.topCell;
        for (int i = 0; i < header.currentDrcResultsCount && (drc = this.readErrorShape()) != null; ++i) {
            v.addError(drc);
        }
        return v;
    }

    private Header readHeader() throws IOException {
        String headerStart = this.readLine();
        if (headerStart == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(headerStart);
        Header header = null;
        try {
            String cur = tokenizer.nextToken();
            String orig = tokenizer.nextToken();
            String len = tokenizer.nextToken();
            int icur = Integer.parseInt(cur);
            int iorig = Integer.parseInt(orig);
            int ilen = Integer.parseInt(len);
            header = new Header(icur, iorig, ilen);
        }
        catch (NoSuchElementException e) {
            System.out.println("Error parsing header start line, expected three integers on line number " + this.lineno + ": " + headerStart);
            return null;
        }
        catch (NumberFormatException e) {
            System.out.println("Error converting count strings to integers on header start line, line number " + this.lineno + ": " + headerStart);
            return null;
        }
        return header;
    }

    private DrcError readErrorShape() throws IOException {
        boolean boolp;
        String nextLine = this.readLine().trim();
        boolean boole = nextLine.startsWith("e");
        boolean bl = boolp = nextLine.startsWith("p");
        if (boole || boolp) {
            String[] parts = nextLine.split(spaces);
            if (parts.length != 3) {
                System.out.println("Error on shape: expected ordinal and count numbers, line number " + this.lineno + ": " + nextLine);
                return null;
            }
            int lines2 = 0;
            try {
                lines2 = Integer.parseInt(parts[2]);
            }
            catch (NumberFormatException e) {
                System.out.println("Error on shape: expected ordinal and count numbers, line number " + this.lineno + ": " + nextLine);
                return null;
            }
            nextLine = this.readLine().trim();
            if (nextLine.startsWith("CN")) {
                parts = nextLine.split(spaces);
                if (parts.length < 3) {
                    System.out.println("Error reading CN line, expected at least three fields, line number " + this.lineno + ": " + nextLine);
                    return null;
                }
                String cellname = parts[1];
                String coordSpace = parts[2];
                if (coordSpace.equals("c")) {
                    this.incell = CalibreDrcErrors.getCell(cellname, this.mangledNames);
                    if (this.incell == null) {
                        this.incell = this.topCell;
                    }
                }
                nextLine = this.readLine();
            }
            DrcError drc = new DrcError(this.incell);
            double lambdaScale = this.incell.getTechnology().getScale() / 1000.0;
            if (boole) {
                for (int i = 0; i < lines2; ++i) {
                    Shape s;
                    if (i != 0) {
                        nextLine = this.readLine();
                    }
                    if ((s = this.parseErrorEdge(nextLine, lambdaScale)) == null) {
                        return drc;
                    }
                    drc.addShape(s);
                }
            } else {
                PolyBase.Point[] points = new PolyBase.Point[lines2];
                for (int i = 0; i < lines2; ++i) {
                    if (i != 0) {
                        nextLine = this.readLine();
                    }
                    if (nextLine.startsWith("SN")) {
                        nextLine = this.readLine();
                    }
                    if (this.parseErrorPoint(nextLine, points, i, lambdaScale)) continue;
                    return null;
                }
                PolyBase s = new PolyBase(points);
                drc.addShape(s);
            }
            return drc;
        }
        System.out.println("Error, expected Edge or Poly definition on line number " + this.lineno + ": " + nextLine);
        return null;
    }

    private Shape parseErrorEdge(String line, double lambdaScale) {
        String[] vals = line.trim().split(spaces);
        if (vals.length != 4) {
            System.out.println("Error, bad format for edge on line number " + this.lineno + ": " + line);
            return null;
        }
        try {
            double x1 = (double)Integer.parseInt(vals[0]) / (double)this.scale / lambdaScale;
            double y1 = (double)Integer.parseInt(vals[1]) / (double)this.scale / lambdaScale;
            double x2 = (double)Integer.parseInt(vals[2]) / (double)this.scale / lambdaScale;
            double y2 = (double)Integer.parseInt(vals[3]) / (double)this.scale / lambdaScale;
            Line2D.Double line2d = new Line2D.Double(x1, y1, x2, y2);
            return line2d;
        }
        catch (NumberFormatException e) {
            System.out.println("Error, bad format for edge on line number " + this.lineno + ": " + line);
            return null;
        }
    }

    private boolean parseErrorPoint(String line, PolyBase.Point[] points, int point, double lambdaScale) {
        String[] vals = line.trim().split(spaces);
        if (vals.length != 2) {
            System.out.println("Error, bad format for poly vertex on line number " + this.lineno + ": " + line);
            return false;
        }
        try {
            PolyBase.Point p;
            double x1 = (double)Integer.parseInt(vals[0]) / (double)this.scale / lambdaScale;
            double y1 = (double)Integer.parseInt(vals[1]) / (double)this.scale / lambdaScale;
            points[point] = p = PolyBase.from(new Point2D.Double(x1, y1));
            return true;
        }
        catch (NumberFormatException e) {
            System.out.println("Error, bad format for poly vertex on line number " + this.lineno + ": " + line);
            return false;
        }
    }

    private int done() {
        try {
            this.in.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        this.logger = ErrorLogger.newInstance("Calibre " + this.type + " Errors");
        int sortKey = 0;
        int count2 = 0;
        for (DrcRuleViolation v : this.ruleViolations) {
            String ruleDesc = v.header.comment.toString().replaceAll("\\n", ";");
            if (!ruleDesc.contains(v.ruleNumber)) {
                ruleDesc = v.ruleNumber + ": " + ruleDesc;
            }
            int y = 1;
            for (DrcError drcError : v.errors) {
                Cell cell = drcError.cell;
                ArrayList<EPoint> lineList = new ArrayList<EPoint>();
                ArrayList<PolyBase> polyList = new ArrayList<PolyBase>();
                for (Shape shape : drcError.shapes) {
                    if (shape instanceof Line2D) {
                        Line2D line = (Line2D)shape;
                        lineList.add(EPoint.fromLambda(line.getX1(), line.getY1()));
                        lineList.add(EPoint.fromLambda(line.getX2(), line.getY2()));
                        continue;
                    }
                    if (shape instanceof PolyBase) {
                        PolyBase poly = (PolyBase)shape;
                        polyList.add(poly);
                        continue;
                    }
                    System.out.println("Unsupported drc error shape " + shape);
                }
                this.logger.logMessageWithLines(y + ". " + cell.getName() + ": " + ruleDesc, polyList, lineList, cell, sortKey, true);
                ++y;
                ++count2;
            }
            this.logger.setGroupName(sortKey, "(" + (y - 1) + ") " + ruleDesc);
            ++sortKey;
        }
        System.out.println(this.type + " Imported " + count2 + " errors from " + this.filename);
        if (count2 == 0 && !this.noPopupMessages) {
            Job.getUserInterface().showInformationMessage(this.type + " Imported Zero Errors", this.type + " Import Complete");
        }
        this.logger.termLogging(!this.noPopupMessages);
        return this.logger.getNumErrors();
    }

    private String readLine() throws IOException {
        return this.readLine(true);
    }

    private String readLine(boolean errorOnEOF) throws IOException {
        if (this.in == null) {
            return null;
        }
        String line = this.in.readLine();
        if (line == null && errorOnEOF) {
            System.out.println("Unexpected End of File!");
            this.in = null;
            return null;
        }
        ++this.lineno;
        return line;
    }

    public static Cell getCell(String cellName, Map<Cell, String> mangledNames) {
        ArrayList<Cell> matchedNames = new ArrayList<Cell>();
        for (Map.Entry<Cell, String> entry : mangledNames.entrySet()) {
            String name = entry.getValue();
            if (!name.equals(cellName)) continue;
            matchedNames.add(entry.getKey());
        }
        if (matchedNames.size() == 0) {
            return null;
        }
        if (matchedNames.size() == 1) {
            return (Cell)matchedNames.get(0);
        }
        UserInterface ui = Job.getUserInterface();
        String[] choices = new String[matchedNames.size()];
        for (int i = 0; i < choices.length; ++i) {
            choices[i] = ((Cell)matchedNames.get(i)).describe(false);
        }
        int c = ui.askForChoice("Multiple cells matches, please choose one for \"" + cellName + "\":", "Ambiguity Found", choices, choices[0]);
        return (Cell)matchedNames.get(c);
    }

    public static void readDensityErrors(Cell cell, File drcDirectory) {
        if (drcDirectory == null || !drcDirectory.exists() || !drcDirectory.isDirectory()) {
            System.out.println("DRC density errors: no such directory: " + drcDirectory.getAbsolutePath());
            return;
        }
        ErrorLogger logger = ErrorLogger.newInstance("Calibre DRC Density Values");
        int sortKey = 0;
        double scale = cell.getTechnology().getScale();
        for (File file : drcDirectory.listFiles()) {
            if (!file.getName().endsWith(".density")) continue;
            try {
                FileReader reader = new FileReader(file);
                BufferedReader in = new BufferedReader(reader);
                String line = null;
                int lineno = 0;
                boolean first = true;
                while ((line = in.readLine()) != null) {
                    ++lineno;
                    if (line.equals("")) continue;
                    String[] parts = line.split("[ ]+");
                    if (parts.length != 5) {
                        System.out.println("Ignoring line " + file.getName() + "." + lineno + ": " + line);
                        continue;
                    }
                    if (first) {
                        logger.setGroupName(sortKey, file.getName());
                        first = false;
                    }
                    double x1 = Double.valueOf(parts[0]) / scale * 1000.0;
                    double y1 = Double.valueOf(parts[1]) / scale * 1000.0;
                    double x2 = Double.valueOf(parts[2]) / scale * 1000.0;
                    double y2 = Double.valueOf(parts[3]) / scale * 1000.0;
                    PolyBase poly = new PolyBase(PolyBase.fromLambda(x1, y1), PolyBase.fromLambda(x1, y2), PolyBase.fromLambda(x2, y2), PolyBase.fromLambda(x2, y1));
                    logger.logError(file.getName() + ": " + parts[4], poly, cell, sortKey);
                }
                if (!first) {
                    ++sortKey;
                }
                reader.close();
            }
            catch (IOException e) {
                System.out.println("Error read file " + file.getName() + ": " + e.getMessage());
            }
        }
        logger.termLogging(false);
    }

    private static class Header {
        private final int currentDrcResultsCount;
        private final int headerLength;
        private StringBuffer comment;

        private Header(int currentDrcResultsCount, int originalDrcResultsCount, int headerLength) {
            this.currentDrcResultsCount = currentDrcResultsCount;
            this.headerLength = headerLength;
            this.comment = new StringBuffer();
        }

        public void addHeaderLine(String line) {
            if (!line.startsWith("Rule File Pathname") && !line.startsWith("Rule File Title")) {
                if (this.comment.length() != 0) {
                    this.comment.append("\n");
                }
                this.comment.append(line);
            }
        }
    }

    private static class DrcError {
        private final Cell cell;
        private final List<Shape> shapes;

        private DrcError(Cell cell) {
            this.cell = cell;
            this.shapes = new ArrayList<Shape>();
        }

        private void addShape(Shape shape) {
            this.shapes.add(shape);
        }
    }

    private static class DrcRuleViolation {
        private final String ruleNumber;
        private final Header header;
        private final List<DrcError> errors;

        private DrcRuleViolation(String ruleNumber, Header header) {
            this.ruleNumber = ruleNumber;
            this.header = header;
            this.errors = new ArrayList<DrcError>();
        }

        private void addError(DrcError error) {
            this.errors.add(error);
        }
    }
}

