/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io;

import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.tool.Job;
import java.io.DataInputStream;
import java.util.ArrayList;
import java.util.List;

public class GDSReader {
    private static final DatatypeSymbol TYPEERR = new DatatypeSymbol();
    private static final DatatypeSymbol TYPENONE = new DatatypeSymbol();
    private static final DatatypeSymbol TYPEFLAGS = new DatatypeSymbol();
    private static final DatatypeSymbol TYPESHORT = new DatatypeSymbol();
    private static final DatatypeSymbol TYPELONG = new DatatypeSymbol();
    private static final DatatypeSymbol TYPEFLOAT = new DatatypeSymbol();
    private static final DatatypeSymbol TYPEDOUBLE = new DatatypeSymbol();
    private static final DatatypeSymbol TYPESTRING = new DatatypeSymbol();
    private static final double twoTo32 = GDSReader.makePower(2, 32);
    private static final double twoToNeg56 = 1.0 / GDSReader.makePower(2, 56);
    private DataInputStream dataInputStream;
    private DatatypeSymbol valuetype;
    private long fileLength;
    private String filePath;
    private short dataWord;
    private byte recordType;
    private byte dataType;
    private long byteCount;
    private int recordCount;
    private int tokenFlags;
    private int tokenValue16;
    private int tokenValue32;
    private double tokenValueDouble;
    private String tokenString;
    private GSymbol theToken;
    public static final GSymbol GDS_HEADER = new GSymbol(0);
    public static final GSymbol GDS_BGNLIB = new GSymbol(1);
    public static final GSymbol GDS_LIBNAME = new GSymbol(2);
    public static final GSymbol GDS_UNITS = new GSymbol(3);
    public static final GSymbol GDS_ENDLIB = new GSymbol(4);
    public static final GSymbol GDS_BGNSTR = new GSymbol(5);
    public static final GSymbol GDS_STRNAME = new GSymbol(6);
    public static final GSymbol GDS_ENDSTR = new GSymbol(7);
    public static final GSymbol GDS_BOUNDARY = new GSymbol(8);
    public static final GSymbol GDS_PATH = new GSymbol(9);
    public static final GSymbol GDS_SREF = new GSymbol(10);
    public static final GSymbol GDS_AREF = new GSymbol(11);
    public static final GSymbol GDS_TEXTSYM = new GSymbol(12);
    public static final GSymbol GDS_LAYER = new GSymbol(13);
    public static final GSymbol GDS_DATATYPSYM = new GSymbol(14);
    public static final GSymbol GDS_WIDTH = new GSymbol(15);
    public static final GSymbol GDS_XY = new GSymbol(16);
    public static final GSymbol GDS_ENDEL = new GSymbol(17);
    public static final GSymbol GDS_SNAME = new GSymbol(18);
    public static final GSymbol GDS_COLROW = new GSymbol(19);
    public static final GSymbol GDS_TEXTNODE = new GSymbol(20);
    public static final GSymbol GDS_NODE = new GSymbol(21);
    public static final GSymbol GDS_TEXTTYPE = new GSymbol(22);
    public static final GSymbol GDS_PRESENTATION = new GSymbol(23);
    public static final GSymbol GDS_STRING = new GSymbol(25);
    public static final GSymbol GDS_STRANS = new GSymbol(26);
    public static final GSymbol GDS_MAG = new GSymbol(27);
    public static final GSymbol GDS_ANGLE = new GSymbol(28);
    public static final GSymbol GDS_REFLIBS = new GSymbol(31);
    public static final GSymbol GDS_FONTS = new GSymbol(32);
    public static final GSymbol GDS_PATHTYPE = new GSymbol(33);
    public static final GSymbol GDS_GENERATIONS = new GSymbol(34);
    public static final GSymbol GDS_ATTRTABLE = new GSymbol(35);
    public static final GSymbol GDS_ELFLAGS = new GSymbol(38);
    public static final GSymbol GDS_NODETYPE = new GSymbol(42);
    public static final GSymbol GDS_PROPATTR = new GSymbol(43);
    public static final GSymbol GDS_PROPVALUE = new GSymbol(44);
    public static final GSymbol GDS_BOX = new GSymbol(45);
    public static final GSymbol GDS_BOXTYPE = new GSymbol(46);
    public static final GSymbol GDS_PLEX = new GSymbol(47);
    public static final GSymbol GDS_BGNEXTN = new GSymbol(48);
    public static final GSymbol GDS_ENDEXTN = new GSymbol(49);
    public static final GSymbol GDS_IDENT = new GSymbol(54);
    public static final GSymbol GDS_REALNUM = new GSymbol(55);
    public static final GSymbol GDS_SHORT_NUMBER = new GSymbol(56);
    public static final GSymbol GDS_NUMBER = new GSymbol(57);
    public static final GSymbol GDS_FLAGSYM = new GSymbol(58);
    public static final GSymbol GDS_FORMAT = new GSymbol(59);
    public static final GSymbol GDS_MASK = new GSymbol(60);
    public static final GSymbol GDS_ENDMASKS = new GSymbol(61);

    public GDSReader(String filePath, DataInputStream dataInputStream, long fileLength) {
        this.filePath = filePath;
        this.dataInputStream = dataInputStream;
        this.fileLength = fileLength;
        this.byteCount = 0L;
        this.recordCount = 0;
    }

    public void getToken() throws Exception {
        if (this.recordCount == 0) {
            this.valuetype = this.readRecord();
        } else {
            if (this.valuetype == TYPEFLAGS) {
                this.tokenFlags = this.getWord();
                this.theToken = GDS_FLAGSYM;
                return;
            }
            if (this.valuetype == TYPESHORT) {
                this.tokenValue16 = this.getWord();
                this.theToken = GDS_SHORT_NUMBER;
                return;
            }
            if (this.valuetype == TYPELONG) {
                this.tokenValue32 = this.getInteger();
                this.theToken = GDS_NUMBER;
                return;
            }
            if (this.valuetype == TYPEFLOAT) {
                this.tokenValueDouble = this.getFloat();
                this.theToken = GDS_REALNUM;
                return;
            }
            if (this.valuetype == TYPEDOUBLE) {
                this.tokenValueDouble = this.getDouble();
                this.theToken = GDS_REALNUM;
                return;
            }
            if (this.valuetype == TYPESTRING) {
                this.tokenString = this.getString();
                this.theToken = GDS_IDENT;
                return;
            }
            if (this.valuetype == TYPEERR) {
                this.handleError("Invalid GDS II datatype");
            }
        }
    }

    public GSymbol getTokenType() {
        return this.theToken;
    }

    public int getRemainingDataCount() {
        return this.recordCount;
    }

    public int getFlagsValue() {
        return this.tokenFlags;
    }

    public int getShortValue() {
        return this.tokenValue16;
    }

    public int getIntValue() {
        return this.tokenValue32;
    }

    public double getDoubleValue() {
        return this.tokenValueDouble;
    }

    public String getStringValue() {
        return this.tokenString;
    }

    public short getLastDataWord() {
        return this.dataWord;
    }

    public byte getLastRecordType() {
        return this.recordType;
    }

    public byte getLastDataType() {
        return this.dataType;
    }

    public void handleError(String msg) throws GDSException {
        String message = "Error: " + msg + " at byte " + this.byteCount + " in '" + this.filePath + "'";
        throw new GDSException(message);
    }

    private DatatypeSymbol readRecord() throws Exception {
        this.dataWord = (short)this.getWord();
        this.recordCount = this.dataWord - 2;
        this.recordType = (byte)(this.getByte() & 0xFF);
        this.theToken = GSymbol.findSymbol(this.recordType);
        this.dataType = this.getByte();
        switch (this.dataType) {
            case 0: {
                return TYPENONE;
            }
            case 1: {
                return TYPEFLAGS;
            }
            case 2: {
                return TYPESHORT;
            }
            case 3: {
                return TYPELONG;
            }
            case 4: {
                return TYPEFLOAT;
            }
            case 5: {
                return TYPEDOUBLE;
            }
            case 6: {
                return TYPESTRING;
            }
        }
        return TYPEERR;
    }

    private float getFloat() throws Exception {
        int reg = this.getByte() & 0xFF;
        int sign2 = 1;
        if ((reg & 0x80) != 0) {
            sign2 = -1;
        }
        int binary_exponent = (reg &= 0x7F) - 64 << 2;
        reg = (this.getByte() & 0xFF) << 16;
        int dataword = this.getWord();
        reg += dataword;
        int shift_count = 0;
        while ((reg & 0x800000) == 0) {
            reg <<= 1;
            ++shift_count;
        }
        if ((binary_exponent = binary_exponent - shift_count - 24) > 0) {
            return (float)((double)(sign2 * reg) * GDSReader.makePower(2, binary_exponent));
        }
        if (binary_exponent < 0) {
            return (float)((double)(sign2 * reg) / GDSReader.makePower(2, -binary_exponent));
        }
        return sign2 * reg;
    }

    private static double makePower(int val, int power) {
        return Math.pow(val, power);
    }

    private double getDouble() throws Exception {
        int long_integer;
        int register1 = this.getByte() & 0xFF;
        double realValue = 1.0;
        if ((register1 & 0x80) != 0) {
            realValue = -1.0;
        }
        int exponent2 = (register1 &= 0x7F) - 64;
        register1 = (this.getByte() & 0xFF) << 16;
        int dataword = this.getWord();
        int register2 = long_integer = this.getInteger();
        if ((register1 += dataword) != 0 || register2 != 0) {
            while ((register1 & 0xF00000) == 0) {
                register1 = (register1 << 4) + (register2 >> 28);
                register2 <<= 4;
                --exponent2;
            }
        } else {
            return 0.0;
        }
        realValue *= ((double)register1 * twoTo32 + (double)register2) * twoToNeg56;
        if (exponent2 > 0) {
            double pow = GDSReader.makePower(16, exponent2);
            realValue *= pow;
        } else if (exponent2 < 0) {
            double pow = GDSReader.makePower(16, -exponent2);
            realValue /= pow;
        }
        return realValue;
    }

    private String getString() throws Exception {
        StringBuffer sb = new StringBuffer();
        while (this.recordCount != 0) {
            char letter2 = (char)this.getByte();
            if (letter2 == '\u0000') continue;
            sb.append(letter2);
        }
        return sb.toString();
    }

    private int getInteger() throws Exception {
        int highWord = this.getWord();
        int lowWord = this.getWord();
        return highWord << 16 | lowWord;
    }

    private int getWord() throws Exception {
        int highByte = this.getByte() & 0xFF;
        int lowByte = this.getByte() & 0xFF;
        return highByte << 8 | lowByte;
    }

    public byte getByte() throws Exception {
        byte b = this.dataInputStream.readByte();
        this.updateProgressDialog(1);
        --this.recordCount;
        return b;
    }

    public String determineTime() throws Exception {
        String[] time_array = new String[7];
        for (int i = 0; i < 6; ++i) {
            if (this.theToken != GDS_SHORT_NUMBER) {
                this.handleError("Date value is not a valid number");
            }
            if (i == 0 && this.getShortValue() < 1900) {
                this.tokenValue16 = this.getShortValue() > 60 ? (this.tokenValue16 += 1900) : (this.tokenValue16 += 2000);
            }
            time_array[i] = Integer.toString(this.tokenValue16);
            this.getToken();
        }
        return time_array[1] + "-" + time_array[2] + "-" + time_array[0] + " at " + time_array[3] + ":" + time_array[4] + ":" + time_array[5];
    }

    private void updateProgressDialog(int bytesRead) {
        this.byteCount += (long)bytesRead;
        if (this.fileLength == 0L) {
            return;
        }
        long pct = this.byteCount * 100L / this.fileLength;
        UserInterface ui = Job.getUserInterface();
        if (ui != null) {
            ui.setProgressValue((int)pct);
        }
    }

    public static class GDSException
    extends Exception {
        private String msg;

        public GDSException(String msg) {
            this.msg = msg;
        }

        @Override
        public String getMessage() {
            return this.msg;
        }
    }

    public static class GSymbol {
        private static List<GSymbol> symbols = new ArrayList<GSymbol>();

        private GSymbol(int value2) {
            while (symbols.size() <= value2) {
                symbols.add(null);
            }
            symbols.set(value2, this);
        }

        private static GSymbol findSymbol(int value2) {
            if (value2 >= 0 && value2 < symbols.size()) {
                return symbols.get(value2);
            }
            return null;
        }
    }

    private static class DatatypeSymbol {
        private DatatypeSymbol() {
        }
    }
}

