/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.ExportId;
import com.sun.electric.database.id.IdReader;
import com.sun.electric.database.id.IdWriter;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.user.ErrorHighArc;
import com.sun.electric.tool.user.ErrorHighExport;
import com.sun.electric.tool.user.ErrorHighLine;
import com.sun.electric.tool.user.ErrorHighNode;
import com.sun.electric.tool.user.ErrorHighPoint;
import com.sun.electric.tool.user.ErrorHighPoly;
import com.sun.electric.tool.user.Highlighter;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.List;

public abstract class ErrorHighlight
implements Serializable {
    public static final ErrorHighlight[] NULL_ARRAY = new ErrorHighlight[0];
    private static final byte HAS_CELL_ID = 8;
    private final CellId cellId;
    private final VarContext context;

    ErrorHighlight(Cell c, VarContext con) {
        this.cellId = c != null ? c.getId() : null;
        this.context = con;
    }

    ErrorHighlight(CellId cellId) {
        this.cellId = cellId;
        this.context = null;
    }

    public Cell getCell(EDatabase database) {
        if (database == null) {
            return null;
        }
        return this.cellId != null ? database.getCell(this.cellId) : null;
    }

    protected String getCellName(EDatabase database) {
        Cell c = this.getCell(database);
        return c != null ? c.describe(false) : "NotFound{lay}";
    }

    VarContext getVarContext() {
        return this.context;
    }

    boolean containsObject(Cell cell, Object obj) {
        return false;
    }

    Object getObject(EDatabase database) {
        return null;
    }

    static String getImplementedXmlHeaders() {
        return "ERRORTYPEGEOM|ERRORTYPETHICKLINE|ERRORTYPELINE|ERRORTYPEPOINT|ERRORTYPEPOLY";
    }

    static boolean isErrorHighlightBody(String name) {
        return name.equals("ERRORTYPEGEOM") || name.equals("ERRORTYPETHICKLINE") || name.equals("ERRORTYPELINE") || name.equals("ERRORTYPEPOINT") || ErrorHighlight.isErrorPoly(name);
    }

    static boolean isErrorPoly(String name) {
        return name.equals("ERRORTYPEPOLY");
    }

    static List<ErrorHighlight> addErrorHighlight(String qName, Cell curCell, String geomName, EPoint p1, EPoint p2, List<ErrorHighlight> list2) {
        List<ErrorHighlight> l = list2;
        boolean geoTypeBody = qName.equals("ERRORTYPEGEOM");
        if (geoTypeBody) {
            assert (curCell != null);
            Geometric geom = curCell.findNode(geomName);
            if (geom == null) {
                geom = curCell.findArc(geomName);
            }
            if (geom != null) {
                list2.add(ErrorHighlight.newInstance(null, geom));
            } else {
                System.out.println("Invalid geometry " + geomName + " in " + curCell);
            }
        } else {
            boolean thickLineTypeBody = qName.equals("ERRORTYPETHICKLINE");
            boolean thinLineTypeBody = qName.equals("ERRORTYPELINE");
            if (thinLineTypeBody || thickLineTypeBody) {
                list2.add(new ErrorHighLine(curCell, p1, p2, thickLineTypeBody));
            } else if (qName.equals("ERRORTYPEPOLY")) {
                ErrorHighPoly poly = new ErrorHighPoly(curCell, null, null);
                list2.add(poly);
                l = poly.linesList;
            } else if (qName.equals("ERRORTYPEPOINT")) {
                list2.add(new ErrorHighPoint(curCell, p1));
            } else assert (false);
        }
        return l;
    }

    public static void writeXmlHeader(String indent, PrintStream ps) {
        System.out.println("Not implemented in writeXmlHeader");
    }

    void writeXmlDescription(String tabs, PrintStream msg, EDatabase database) {
        System.out.println("Not implemented in writeXmlDescription");
    }

    boolean isValid(EDatabase database) {
        return this.cellId == null || this.getCell(database) != null;
    }

    public void addToHighlighter(Highlighter h, EDatabase database) {
    }

    public static ErrorHighlight newInstance(VarContext cont, Geometric geom) {
        if (geom instanceof NodeInst) {
            return new ErrorHighNode(cont, (NodeInst)geom);
        }
        return new ErrorHighArc(cont, (ArcInst)geom);
    }

    public static ErrorHighlight newInstance(CellId cellId, ImmutableNodeInst n) {
        return new ErrorHighNode(cellId, n.nodeId);
    }

    public static ErrorHighlight newInstance(Cell cell, Point2D p1, Point2D p2) {
        return new ErrorHighLine(cell, EPoint.snap(p1), EPoint.snap(p2), false);
    }

    public static ErrorHighlight newInstance(Cell cell, Point2D pt) {
        return new ErrorHighPoint(cell, EPoint.snap(pt));
    }

    public static ErrorHighlight newInstance(Export e) {
        return new ErrorHighExport(null, e);
    }

    abstract void write(IdWriter var1) throws IOException;

    void writeTag(IdWriter writer, byte tag) throws IOException {
        if (this.cellId != null) {
            writer.writeByte((byte)(tag | 8));
            writer.writeNodeProtoId(this.cellId);
        } else {
            writer.writeByte(tag);
        }
    }

    static ErrorHighlight read(IdReader reader) throws IOException {
        byte tag = reader.readByte();
        CellId cellId = null;
        if ((tag & 8) != 0) {
            cellId = (CellId)reader.readNodeProtoId();
            tag = (byte)(tag & 0xFFFFFFF7);
        }
        switch (tag) {
            case 1: {
                ExportId pp = (ExportId)reader.readPortProtoId();
                return new ErrorHighExport(pp);
            }
            case 2: {
                ErrorHighPoly ehp = new ErrorHighPoly(cellId);
                int numLines = reader.readInt();
                for (int i = 0; i < numLines; ++i) {
                    ehp.linesList.add(ErrorHighlight.read(reader));
                }
                return ehp;
            }
            case 3: {
                EPoint p1 = reader.readPoint();
                EPoint p2 = reader.readPoint();
                boolean thickLine = reader.readBoolean();
                return new ErrorHighLine(cellId, p1, p2, thickLine);
            }
            case 4: {
                EPoint point = reader.readPoint();
                return new ErrorHighPoint(cellId, point);
            }
            case 5: {
                int nodeId = reader.readNodeId();
                return new ErrorHighNode(cellId, nodeId);
            }
            case 6: {
                int arcId = reader.readArcId();
                return new ErrorHighArc(cellId, arcId);
            }
        }
        throw new NotSerializableException();
    }
}

