/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.change.DatabaseChangeEvent;
import com.sun.electric.database.change.DatabaseChangeListener;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.tool.user.CellChangeJobs;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.menus.CellMenu;
import com.sun.electric.tool.user.ui.PaletteFrame;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CellBrowser
extends EDialog
implements DatabaseChangeListener {
    private static Preferences prefs = Preferences.userNodeForPackage(CellBrowser.class);
    private static final String prefFilter = "CellBrowser-Filter";
    private static final String prefSelectedLib = "CellBrowser-SelectedLib";
    private static final String prefSelectedView = "CellBrowser-SelectedView";
    private static final String prefSelectedCell = "CellBrowser-SelectedCell";
    private static final String prefEditInNewWindow = "CellBrowser-EditInNewWindow";
    private static final String prefSortLexically = "CellBrowser-SortLexically";
    private String lastSelectedLib = null;
    private String lastSelectedView = null;
    private String lastSelectedCell = null;
    private String lastFilter = "";
    private static Pattern lastPattern = null;
    private static boolean confirmDelete = true;
    private boolean cancelled;
    private DoAction action;
    private List<Cell> cellList = null;
    private List<String> cellListNames = null;
    private JCheckBox sortNumerically;
    private JCheckBox editInNewWindow;
    private JLabel newCellNameLabel;
    private JTextField newCellName;
    private JCheckBox confirmDeletions;
    private JButton cancel;
    private JTextField cellFilter;
    private JButton doAction;
    private JButton done;
    private JPanel extrasPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JList jList1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JComboBox libraryComboBox;
    private JComboBox viewComboBox;

    public CellBrowser(Frame parent, boolean modal, DoAction action) {
        super(parent, modal);
        this.action = action;
        this.cancelled = false;
        this.initComponents();
        this.setTitle(action.title);
        this.doAction.setText(action.name);
        this.getRootPane().setDefaultButton(this.doAction);
        this.lastFilter = prefs.get(action + prefFilter, "");
        lastPattern = Pattern.compile(this.lastFilter);
        this.lastSelectedCell = prefs.get(action + prefSelectedCell, null);
        this.cellFilter.setText(this.lastFilter);
        this.initExtras();
        this.initComboBoxes();
        UserInterfaceMain.addDatabaseChangeListener(this);
        this.finishInitialization();
        this.pack();
    }

    @Override
    public void databaseChanged(DatabaseChangeEvent e) {
        if (!this.isVisible()) {
            return;
        }
        this.updateCellList();
    }

    @Override
    protected void escapePressed() {
        this.cancelActionPerformed(null);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.libraryComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.viewComboBox = new JComboBox();
        this.jLabel3 = new JLabel();
        this.cellFilter = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.jPanel1 = new JPanel();
        this.cancel = new JButton();
        this.doAction = new JButton();
        this.done = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.extrasPanel = new JPanel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                CellBrowser.this.closeDialog(evt);
            }
        });
        this.jLabel1.setText("Library:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.libraryComboBox.setFont(new Font("Dialog", 0, 12));
        this.libraryComboBox.setMinimumSize(new Dimension(32, 20));
        this.libraryComboBox.setPreferredSize(new Dimension(32, 20));
        this.libraryComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                CellBrowser.this.libraryComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)this.libraryComboBox, gridBagConstraints);
        this.jLabel2.setText("View:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.viewComboBox.setFont(new Font("Dialog", 0, 12));
        this.viewComboBox.setMinimumSize(new Dimension(32, 20));
        this.viewComboBox.setPreferredSize(new Dimension(32, 20));
        this.viewComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                CellBrowser.this.viewComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)this.viewComboBox, gridBagConstraints);
        this.jLabel3.setText("Filter:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(7, 4, 7, 4);
        this.getContentPane().add((Component)this.jLabel3, gridBagConstraints);
        this.cellFilter.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                CellBrowser.this.cellFilterKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)this.cellFilter, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CellBrowser.this.cancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.cancel, gridBagConstraints);
        this.doAction.setText("doAction");
        this.doAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CellBrowser.this.doActionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.doAction, gridBagConstraints);
        this.done.setText("Done");
        this.done.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CellBrowser.this.doneActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.done, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jScrollPane1.setPreferredSize(new Dimension(230, 350));
        this.jList1.setSelectionMode(0);
        this.jList1.setPreferredSize(new Dimension(150, 300));
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                CellBrowser.this.jList1ValueChanged(evt);
            }
        });
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                CellBrowser.this.jList1MouseClicked(null);
            }
        });
        this.jList1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                CellBrowser.this.jList1MouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.extrasPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.extrasPanel, gridBagConstraints);
        this.pack();
    }

    private void initComboBoxes() {
        Cell cell;
        this.libraryComboBox.addItem("All");
        this.lastSelectedLib = prefs.get(this.action + prefSelectedLib, null);
        if (this.lastSelectedLib == null && (cell = WindowFrame.getCurrentCell()) != null) {
            this.lastSelectedLib = cell.getLibrary().getName();
        }
        int curLibIndex = -1;
        int curIndex = -1;
        int i = 1;
        for (Library lib : Library.getVisibleLibraries()) {
            this.libraryComboBox.addItem(lib.getName());
            if (lib.getName().equals(this.lastSelectedLib)) {
                curIndex = i;
            }
            if (lib == Library.getCurrent()) {
                curLibIndex = i;
            }
            ++i;
        }
        if (curIndex == -1) {
            curIndex = curLibIndex;
        }
        if (curIndex > 0) {
            this.libraryComboBox.setSelectedIndex(curIndex);
        }
        this.viewComboBox.addItem("All");
        this.lastSelectedView = prefs.get(this.action + prefSelectedView, null);
        curIndex = -1;
        i = 1;
        List<View> viewList = View.getOrderedViews();
        for (View view : viewList) {
            this.viewComboBox.addItem(view.getFullName());
            if (view.getFullName().equals(this.lastSelectedView)) {
                curIndex = i;
            }
            ++i;
        }
        if (curIndex == -1) {
            curIndex = 0;
        }
        this.viewComboBox.setSelectedIndex(curIndex);
    }

    private void initExtras() {
        int yPos = 0;
        boolean lexSort = prefs.getBoolean(prefSortLexically, false);
        this.sortNumerically = new JCheckBox("Evaluate Numbers when Sorting Names", !lexSort);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = yPos++;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.extrasPanel.add((Component)this.sortNumerically, gridBagConstraints);
        this.sortNumerically.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                CellBrowser.this.updateCellList();
            }
        });
        if (this.action == DoAction.newInstance) {
            this.doAction.setText("New Instance");
            this.done.setText("New Instance & Close");
        } else if (this.action == DoAction.editCell) {
            boolean checked = prefs.getBoolean(prefEditInNewWindow, false);
            this.editInNewWindow = new JCheckBox("Edit in New Window", checked);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = yPos++;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 1;
            this.extrasPanel.add((Component)this.editInNewWindow, gridBagConstraints);
            this.jPanel1.remove(this.done);
            this.jList1.setSelectionMode(2);
        } else if (this.action == DoAction.renameCell) {
            this.newCellNameLabel = new JLabel("New Cell Name:  ");
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = yPos;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 1;
            this.extrasPanel.add((Component)this.newCellNameLabel, gridBagConstraints);
            this.newCellName = new JTextField();
            if (this.lastSelectedCell != null) {
                String nameOnly = this.lastSelectedCell.replaceAll("\\{.*?\\}", "");
                this.newCellName.setText(nameOnly);
            }
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = yPos++;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 1;
            this.extrasPanel.add((Component)this.newCellName, gridBagConstraints);
            this.doAction.setText("Apply Rename");
        } else if (this.action == DoAction.deleteCell) {
            this.confirmDeletions = new JCheckBox("Confirm Deletions", confirmDelete);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = yPos++;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 1;
            this.extrasPanel.add((Component)this.confirmDeletions, gridBagConstraints);
            Cell cell = WindowFrame.getCurrentCell();
            this.setCell(cell);
            this.jList1.setSelectionMode(2);
            this.doAction.setText("Apply Delete");
        } else if (this.action == DoAction.duplicateCell || this.action == DoAction.selectCellToAssoc) {
            Cell cell = WindowFrame.getCurrentCell();
            this.setCell(cell);
            this.jPanel1.remove(this.done);
        }
    }

    private void jList1ValueChanged(ListSelectionEvent evt) {
        int index = this.jList1.getSelectedIndex();
        this.jList1.ensureIndexIsVisible(index);
        if (this.jList1.getSelectedValue() != null) {
            this.lastSelectedCell = (String)this.jList1.getSelectedValue();
        }
        if (this.action == DoAction.renameCell && this.lastSelectedCell != null && this.newCellName != null) {
            String nameOnly = this.lastSelectedCell.replaceAll("\\{.*?\\}", "");
            this.newCellName.setText(nameOnly);
        }
    }

    private void cellFilterKeyReleased(KeyEvent evt) {
        this.updateCellList();
    }

    private void viewComboBoxItemStateChanged(ItemEvent evt) {
        this.updateCellList();
    }

    private void libraryComboBoxItemStateChanged(ItemEvent evt) {
        this.updateCellList();
    }

    private void jList1MouseClicked(MouseEvent evt) {
        if (evt != null) {
            if (evt.getClickCount() >= 2) {
                this.performAction();
            }
        } else if (this.jList1.getSelectedValue() != null) {
            this.lastSelectedCell = (String)this.jList1.getSelectedValue();
        }
    }

    private void doActionActionPerformed(ActionEvent evt) {
        this.performAction();
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.cancelled = true;
        this.closeDialog(null);
    }

    private void doneActionPerformed(ActionEvent evt) {
        if (this.action == DoAction.newInstance) {
            this.performAction();
        }
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        prefs.put(this.action + prefSelectedLib, (String)this.libraryComboBox.getSelectedItem());
        prefs.put(this.action + prefSelectedView, (String)this.viewComboBox.getSelectedItem());
        if (this.jList1.getSelectedValue() != null) {
            prefs.put(this.action + prefSelectedCell, (String)this.jList1.getSelectedValue());
        }
        prefs.put(this.action + prefFilter, this.lastFilter);
        prefs.putBoolean(prefSortLexically, !this.sortNumerically.isSelected());
        if (this.action == DoAction.editCell) {
            prefs.putBoolean(prefEditInNewWindow, this.editInNewWindow.isSelected());
        } else if (this.action == DoAction.deleteCell) {
            confirmDelete = this.confirmDeletions.isSelected();
        }
        this.setVisible(false);
        UserInterfaceMain.removeDatabaseChangeListener(this);
        this.dispose();
    }

    private void performAction() {
        if (this.action == DoAction.newInstance) {
            Cell cell = this.getSelectedCell();
            if (cell == null) {
                return;
            }
            PaletteFrame.placeInstance(cell, null, false);
        } else if (this.action == DoAction.editCell) {
            boolean newWindow = this.editInNewWindow.isSelected();
            List<Cell> cells = this.getSelectedCells();
            for (Cell cell : cells) {
                WindowFrame wf = WindowFrame.getCurrentWindowFrame();
                if (!newWindow && wf == null) {
                    newWindow = true;
                }
                if (newWindow) {
                    WindowFrame.createEditWindow(cell);
                } else {
                    wf.setCellWindow(cell, null);
                }
                newWindow = true;
            }
            this.closeDialog(null);
        } else if (this.action == DoAction.deleteCell) {
            String name;
            int i;
            confirmDelete = this.confirmDeletions.isSelected();
            List<Cell> cells = this.getSelectedCells();
            HashSet<String> deletedCells = new HashSet<String>();
            for (Cell cell : cells) {
                int response;
                if (confirmDelete && (response = JOptionPane.showConfirmDialog(TopLevel.getCurrentJFrame(), "Are you sure you want to delete '" + cell + "'?", "Confirm Cell Deletion", 0)) != 0) {
                    return;
                }
                CircuitChanges.cleanCellRef(cell);
                deletedCells.add(cell.noLibDescribe());
            }
            new CellChangeJobs.DeleteManyCells(cells);
            this.lastSelectedCell = null;
            for (i = this.cellListNames.size() - 2; i >= 0; --i) {
                name = this.cellListNames.get(i);
                String nextName = this.cellListNames.get(i + 1);
                if (!deletedCells.contains(name) || deletedCells.contains(nextName)) continue;
                this.lastSelectedCell = nextName;
                break;
            }
            if (this.lastSelectedCell == null) {
                for (i = 0; i < this.cellListNames.size(); ++i) {
                    name = this.cellListNames.get(i);
                    if (deletedCells.contains(name)) continue;
                    this.lastSelectedCell = name;
                    break;
                }
            }
            this.updateCellList();
        } else if (this.action == DoAction.renameCell) {
            Cell cell = this.getSelectedCell();
            if (cell == null) {
                return;
            }
            String newName = this.newCellName.getText();
            if (newName == null || newName.equals("")) {
                return;
            }
            CircuitChanges.renameCellInJob(cell, newName);
            this.lastSelectedCell = newName + cell.getView().getAbbreviationExtension();
        } else if (this.action == DoAction.duplicateCell) {
            Cell cell = this.getSelectedCell();
            if (cell == null) {
                return;
            }
            new CellMenu.NewCellName(0, cell, null);
            this.closeDialog(null);
            this.updateCellList();
        } else if (this.action == DoAction.selectCellToAssoc || this.action == DoAction.selectCellToCopy) {
            this.closeDialog(null);
        }
    }

    private void setLibrary(Library lib) {
        String libName = lib.getName();
        this.libraryComboBox.setSelectedItem(libName);
    }

    private void setView(View view) {
        String viewName = view.getFullName();
        this.viewComboBox.setSelectedItem(viewName);
    }

    private void setCell(Cell cell) {
        this.cellFilter.setText("");
        if (cell != null) {
            this.lastSelectedCell = cell.noLibDescribe();
            Library lib = cell.getLibrary();
            this.setLibrary(lib);
            View view = cell.getView();
            this.setView(view);
        }
        this.updateCellList();
    }

    private void updateCellList() {
        Cell cell;
        Iterator<ElectricObject> it;
        Pattern pat;
        String libName = (String)this.libraryComboBox.getSelectedItem();
        String viewName = (String)this.viewComboBox.getSelectedItem();
        String filter2 = this.cellFilter.getText();
        Library lib = Library.findLibrary(libName);
        View view = null;
        Iterator<View> it2 = View.getViews();
        while (it2.hasNext()) {
            View v = it2.next();
            if (!v.getFullName().equals(viewName)) continue;
            view = v;
            break;
        }
        if (filter2.equals("*")) {
            filter2 = "";
        }
        if (filter2.equals(this.lastFilter)) {
            pat = lastPattern;
        } else {
            try {
                pat = Pattern.compile(filter2, 2);
            }
            catch (PatternSyntaxException e) {
                pat = null;
                filter2 = "";
            }
            lastPattern = pat;
            this.lastFilter = filter2;
        }
        this.cellList = new ArrayList<Cell>();
        if (lib == null) {
            it = Library.getLibraries();
            while (it.hasNext()) {
                Library library = (Library)it.next();
                Iterator<Cell> it22 = library.getCells();
                while (it22.hasNext()) {
                    Matcher mat;
                    Cell c = it22.next();
                    if (view != null && view != c.getView() || pat != null && !(mat = pat.matcher(c.noLibDescribe())).find()) continue;
                    this.cellList.add(c);
                }
            }
        } else {
            it = lib.getCells();
            while (it.hasNext()) {
                Matcher mat;
                Cell c = (Cell)it.next();
                if (view != null && view != c.getView() || !filter2.equals("") && !(mat = pat.matcher(c.noLibDescribe())).find()) continue;
                this.cellList.add(c);
            }
        }
        if (this.sortNumerically.isSelected()) {
            Collections.sort(this.cellList);
        } else {
            Collections.sort(this.cellList, new TextUtils.CellsByName());
        }
        this.cellListNames = new ArrayList<String>();
        for (Cell c : this.cellList) {
            this.cellListNames.add(c.noLibDescribe());
        }
        this.jList1.setListData(this.cellListNames.toArray());
        this.doAction.setEnabled(this.cellListNames.size() > 0);
        this.jList1.setVisibleRowCount(this.jList1.getModel().getSize());
        this.jList1.setPreferredSize(this.jList1.getPreferredScrollableViewportSize());
        this.jList1.revalidate();
        if (this.lastSelectedCell != null) {
            int i;
            for (i = 0; i < this.cellListNames.size(); ++i) {
                String name = this.cellListNames.get(i);
                if (!name.equals(this.lastSelectedCell)) continue;
                this.jList1.setSelectedIndex(i);
                break;
            }
            if (i == this.cellListNames.size()) {
                this.lastSelectedCell = null;
            }
        }
        if (this.lastSelectedCell == null && (cell = WindowFrame.getCurrentCell()) != null) {
            String findname = cell.noLibDescribe();
            for (int i = 0; i < this.cellListNames.size(); ++i) {
                String name = this.cellListNames.get(i);
                if (!name.equals(findname)) continue;
                this.jList1.setSelectedIndex(i);
                this.lastSelectedCell = findname;
                break;
            }
        }
    }

    public Cell getSelectedCell() {
        if (this.cancelled) {
            return null;
        }
        int i = this.jList1.getSelectedIndex();
        return i == -1 ? null : this.cellList.get(i);
    }

    private List<Cell> getSelectedCells() {
        int[] is = this.jList1.getSelectedIndices();
        ArrayList<Cell> list2 = new ArrayList<Cell>();
        for (int i = 0; i < is.length; ++i) {
            int celli = is[i];
            Cell cell = this.cellList.get(celli);
            if (cell == null) continue;
            list2.add(cell);
        }
        return list2;
    }

    public static class DoAction {
        public String title;
        public String name;
        public static final DoAction newInstance = new DoAction("New Cell Instance", "Create a Cell Instance");
        public static final DoAction editCell = new DoAction("Edit Cell", "Edit a Cell");
        public static final DoAction renameCell = new DoAction("Rename Cell", "Rename Cells");
        public static final DoAction duplicateCell = new DoAction("Duplicate Cell", "Duplicate a Cell");
        public static final DoAction deleteCell = new DoAction("Delete Cell", "Delete Cells");
        public static final DoAction selectCellToAssoc = new DoAction("Select Cell", "Which Cell is Associated with this Data?");
        public static final DoAction selectCellToCopy = new DoAction("Select Cell", "Copy Parameters from which Cell?");

        private DoAction(String name, String title) {
            this.name = name;
            this.title = title;
        }

        public String toString() {
            return this.name;
        }
    }
}

