/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.util.memory;

import com.sun.electric.util.memory.Memory;

public class MemoryUsage {
    private static MemoryUsage instance = new MemoryUsage();

    private MemoryUsage() {
    }

    public static MemoryUsage getInstance() {
        return instance;
    }

    public long getHeapSize() {
        return Runtime.getRuntime().totalMemory();
    }

    public long getUsedMemory() {
        return this.getHeapSize() - Runtime.getRuntime().freeMemory();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(Memory.formatMemorySize(this.getUsedMemory()));
        builder.append("/");
        builder.append(Memory.formatMemorySize(this.getHeapSize()));
        return builder.toString();
    }

    public static long getMemoryUsage() {
        MemoryUsage.collectGarbage();
        MemoryUsage.collectGarbage();
        return instance.getUsedMemory();
    }

    public static void collectGarbage() {
        try {
            System.gc();
            Thread.sleep(100L);
            System.runFinalization();
            Thread.sleep(100L);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }
}

