/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.ClassTypeWriter;
import gnu.bytecode.ConstantPool;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class CpoolEntry {
    int hash;
    public int index;
    CpoolEntry next;

    public int getIndex() {
        return this.index;
    }

    public abstract int getTag();

    public int hashCode() {
        return this.hash;
    }

    abstract void write(DataOutputStream var1) throws IOException;

    void add_hashed(ConstantPool constantPool) {
        CpoolEntry[] cpoolEntryArray = constantPool.hashTab;
        int n = (this.hash & Integer.MAX_VALUE) % cpoolEntryArray.length;
        this.next = cpoolEntryArray[n];
        cpoolEntryArray[n] = this;
    }

    protected CpoolEntry() {
    }

    public CpoolEntry(ConstantPool constantPool, int n) {
        this.hash = n;
        if (constantPool.locked) {
            throw new Error("adding new entry to locked contant pool");
        }
        this.index = ++constantPool.count;
        if (constantPool.pool == null) {
            constantPool.pool = new CpoolEntry[60];
        } else if (this.index >= constantPool.pool.length) {
            int n2 = constantPool.pool.length;
            int n3 = 2 * constantPool.pool.length;
            CpoolEntry[] cpoolEntryArray = new CpoolEntry[n3];
            for (int i = 0; i < n2; ++i) {
                cpoolEntryArray[i] = constantPool.pool[i];
            }
            constantPool.pool = cpoolEntryArray;
        }
        if (constantPool.hashTab == null || (double)this.index >= 0.6 * (double)constantPool.hashTab.length) {
            constantPool.rehash();
        }
        constantPool.pool[this.index] = this;
        this.add_hashed(constantPool);
    }

    public abstract void print(ClassTypeWriter var1, int var2);
}

