/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Field;
import gnu.bytecode.Filter;
import gnu.bytecode.Location;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.AbstractMethodFilter;
import gnu.expr.ClassInitializer;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.Interpreter;
import gnu.expr.LambdaExp;
import gnu.expr.ObjectExp;
import gnu.expr.PairClassType;
import gnu.expr.Target;
import gnu.mapping.OutPort;
import java.util.Vector;

public class ClassExp
extends LambdaExp {
    boolean simple;
    ClassType instanceType;
    boolean makeClassPair;
    public Expression[] supers;
    public LambdaExp initMethod;
    boolean partsDeclared;

    public boolean isSimple() {
        return this.simple;
    }

    public void setSimple(boolean bl) {
        this.simple = bl;
    }

    public void setMakingClassPair(boolean bl) {
        this.makeClassPair = bl;
    }

    public boolean isMakingClassPair() {
        return this.makeClassPair;
    }

    public ClassExp() {
        this.type = null;
        this.setCanRead(true);
    }

    public void compile(Compilation compilation, Target target) {
        if (target instanceof IgnoreTarget) {
            return;
        }
        ClassType classType = this.compile(compilation);
        this.compilePushClass(compilation, target);
    }

    public void compilePushClass(Compilation compilation, Target target) {
        int n;
        ClassType classType;
        ClassType classType2 = this.type;
        String string = classType2.getName();
        ClassType classType3 = ClassType.make("java.lang.Class");
        Method method = classType3.addMethod("forName", Compilation.string1Arg, classType3, 9);
        CodeAttr codeAttr = compilation.getCode();
        codeAttr.emitPushString(string);
        codeAttr.emitInvokeStatic(method);
        boolean bl = this.getNeedsClosureEnv();
        if (this.isMakingClassPair() || bl) {
            codeAttr.emitPushString(this.instanceType.getName());
            codeAttr.emitInvokeStatic(method);
            classType = ClassType.make("gnu.expr.PairClassType");
            n = bl ? 3 : 2;
        } else {
            classType = ClassType.make("gnu.bytecode.Type");
            n = 1;
        }
        Type[] typeArray = new Type[n];
        if (bl) {
            compilation.curLambda.loadHeapFrame(compilation);
            typeArray[--n] = Type.pointer_type;
        }
        while (--n >= 0) {
            typeArray[n] = classType3;
        }
        Method method2 = classType.addMethod("make", typeArray, classType, 9);
        codeAttr.emitInvokeStatic(method2);
        target.compileFromStack(compilation, classType);
    }

    public String getJavaName() {
        return this.name == null ? "object" : Compilation.mangleNameIfNeeded(this.name);
    }

    public ClassType getCompiledClassType(Compilation compilation) {
        if (!this.partsDeclared) {
            this.getType();
            this.declareParts();
        }
        if (this.type.getName() == null) {
            int n;
            String string = this.getName();
            if (string == null) {
                string = "object";
            } else {
                n = string.length();
                if (n > 2 && string.charAt(0) == '<' && string.charAt(n - 1) == '>') {
                    string = string.substring(1, n - 1);
                }
            }
            if (!this.isSimple() || this instanceof ObjectExp) {
                string = compilation.generateClassName(string);
            } else {
                int n2;
                n = 0;
                StringBuffer stringBuffer = new StringBuffer(100);
                while ((n2 = string.indexOf(46, n)) >= 0) {
                    stringBuffer.append(Compilation.mangleNameIfNeeded(string.substring(n, n2)));
                    stringBuffer.append('.');
                    n = n2 + 1;
                }
                if (n == 0) {
                    int n3;
                    String string2 = compilation.mainClass == null ? null : compilation.mainClass.getName();
                    int n4 = n3 = string2 == null ? -1 : string2.lastIndexOf(46);
                    if (n3 > 0) {
                        stringBuffer.append(string2.substring(0, n3 + 1));
                    } else if (compilation.classPrefix != null) {
                        stringBuffer.append(compilation.classPrefix);
                    }
                }
                if (n < string.length()) {
                    stringBuffer.append(Compilation.mangleNameIfNeeded(string.substring(n)));
                }
                string = stringBuffer.toString();
            }
            this.type.setName(string);
        }
        return this.type;
    }

    void setTypes() {
        ClassType[] classTypeArray;
        ClassType[] classTypeArray2;
        int n = this.supers == null ? 0 : this.supers.length;
        ClassType[] classTypeArray3 = new ClassType[n];
        ClassType classType = null;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            classTypeArray2 = Interpreter.getInterpreter().getTypeFor(this.supers[i]);
            if (classTypeArray2 == null || !(classTypeArray2 instanceof ClassType)) {
                throw new Error("invalid super type");
            }
            ClassType classType2 = (ClassType)classTypeArray2;
            if ((classType2.getModifiers() & 0x200) == 0) {
                if (n2 < i) {
                    throw new Error("duplicate superclass");
                }
                classType = classType2;
                continue;
            }
            classTypeArray3[n2++] = classType2;
        }
        if (classType == null) {
            if (!this.isSimple()) {
                PairClassType pairClassType = new PairClassType();
                this.type = pairClassType;
                this.setMakingClassPair(true);
                this.instanceType = new ClassType();
                this.type.setInterface(true);
                classTypeArray2 = new ClassType[]{this.type};
                this.instanceType.setSuper(Type.pointer_type);
                this.instanceType.setInterfaces(classTypeArray2);
                pairClassType.instanceType = this.instanceType;
            } else {
                this.instanceType = this.type = new ClassType();
            }
            this.type.setSuper(Type.pointer_type);
        } else {
            this.instanceType = this.type = new ClassType();
            this.type.setSuper(classType);
        }
        this.instanceType.setModifiers(32);
        if (n2 == n) {
            classTypeArray = classTypeArray3;
        } else {
            classTypeArray = new ClassType[n2];
            System.arraycopy(classTypeArray3, 0, classTypeArray, 0, n2);
        }
        this.type.setInterfaces(classTypeArray);
    }

    public Type getType() {
        if (this.type == null) {
            this.setTypes();
        }
        return this.type;
    }

    public void declareParts() {
        Object object2;
        if (this.partsDeclared) {
            return;
        }
        this.partsDeclared = true;
        for (object2 = this.firstDecl(); object2 != null; object2 = ((Declaration)object2).nextDecl()) {
            Object object3;
            if (!((Declaration)object2).getCanRead()) continue;
            int n = 1;
            if (((Declaration)object2).getFlag(2048)) {
                n |= 8;
            }
            if (this.isMakingClassPair()) {
                object3 = ((Declaration)object2).getType().getImplementationType();
                this.type.addMethod(ClassExp.slotToMethodName("get", ((Declaration)object2).getName()), n |= 0x400, Type.typeArray0, (Type)object3);
                Type[] typeArray = new Type[]{object3};
                this.type.addMethod(ClassExp.slotToMethodName("set", ((Declaration)object2).getName()), n, typeArray, Type.void_type);
                continue;
            }
            object3 = Compilation.mangleNameIfNeeded(((Declaration)object2).getName());
            ((Declaration)object2).field = this.instanceType.addField((String)object3, ((Declaration)object2).getType(), n);
            ((Declaration)object2).setSimple(false);
        }
        object2 = this.firstChild;
        while (object2 != null) {
            if (object2 != this.initMethod || !this.isMakingClassPair()) {
                ((LambdaExp)object2).addMethodFor(this.type, null, null);
            }
            if (this.isMakingClassPair()) {
                ((LambdaExp)object2).addMethodFor(this.instanceType, null, this.type);
            }
            object2 = ((LambdaExp)object2).nextSibling;
        }
    }

    static void getImplMethods(ClassType classType, String string, Type[] typeArray, Vector vector) {
        Type[] typeArray2;
        ClassType classType2;
        if (classType instanceof PairClassType) {
            classType2 = ((PairClassType)classType).instanceType;
        } else {
            if (!classType.isInterface()) {
                return;
            }
            typeArray2 = classType.getName() + "$class";
            classType2 = ClassType.make((String)typeArray2);
        }
        typeArray2 = new Type[typeArray.length + 1];
        typeArray2[0] = classType;
        System.arraycopy(typeArray, 0, typeArray2, 1, typeArray.length);
        Method method = classType2.getDeclaredMethod(string, typeArray2);
        if (method != null) {
            int n = vector.size();
            if (n == 0 || !vector.elementAt(n - 1).equals(method)) {
                vector.addElement(method);
            }
        } else {
            ClassType[] classTypeArray = classType.getInterfaces();
            for (int i = 0; i < classTypeArray.length; ++i) {
                ClassExp.getImplMethods(classTypeArray[i], string, typeArray, vector);
            }
        }
    }

    private static void usedSuperClasses(ClassType classType, Compilation compilation) {
        compilation.usedClass(classType.getSuperclass());
        ClassType[] classTypeArray = classType.getInterfaces();
        if (classTypeArray != null) {
            int n = classTypeArray.length;
            while (--n >= 0) {
                compilation.usedClass(classTypeArray[n]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassType compile(Compilation compilation) {
        ClassType classType = compilation.curClass;
        Method method = compilation.method;
        try {
            Object object2;
            Object object3;
            String string;
            ClassType classType2;
            compilation.curClass = classType2 = this.getCompiledClassType(compilation);
            ClassExp.usedSuperClasses(this.type, compilation);
            if (this.type != this.instanceType) {
                ClassExp.usedSuperClasses(this.instanceType, compilation);
            }
            if ((string = this.getFile()) != null) {
                classType2.setSourceFile(string);
            }
            LambdaExp lambdaExp = compilation.curLambda;
            compilation.curLambda = this;
            this.allocFrame(compilation);
            if (this.getNeedsStaticLink()) {
                Object object4 = object3 = lambdaExp.heapFrame != null ? lambdaExp.heapFrame : lambdaExp.closureEnv;
                if (object3 != null) {
                    this.closureEnvField = this.staticLinkField = this.instanceType.addField("this$0", ((Location)object3).getType());
                }
            }
            compilation.generateConstructor(this.instanceType, this);
            Object object5 = this.firstChild;
            while (object5 != null) {
                Method method2 = compilation.method;
                object2 = compilation.curLambda;
                compilation.method = object5.getMainMethod();
                object5.declareThis(compilation.curClass);
                compilation.curClass = this.instanceType;
                compilation.curLambda = object5;
                compilation.method.initCode();
                object5.allocChildClasses(compilation);
                object5.allocParameters(compilation);
                object5.enterFunction(compilation);
                object5.compileBody(compilation);
                object5.compileEnd(compilation);
                object5.compileChildMethods(compilation);
                compilation.method = method2;
                compilation.curClass = classType2;
                compilation.curLambda = object2;
                object5 = object5.nextSibling;
            }
            object5 = this.type.getMethods((Filter)AbstractMethodFilter.instance, 2);
            for (int i = 0; i < ((Method[])object5).length; ++i) {
                Object object6;
                Object object7;
                Object object8;
                char c;
                object2 = object5[i];
                String string2 = ((Method)object2).getName();
                Type[] typeArray = ((Method)object2).getParameterTypes();
                Type type = ((Method)object2).getReturnType();
                Method method3 = this.instanceType.getMethod(string2, typeArray);
                if (method3 != null && !method3.isAbstract()) continue;
                if (string2.length() > 3 && string2.charAt(2) == 't' && string2.charAt(1) == 'e' && ((c = string2.charAt(0)) == 'g' || c == 's')) {
                    if (c == 's' && type.isVoid() && typeArray.length == 1) {
                        object8 = typeArray[0];
                    } else {
                        if (c != 'g' || typeArray.length != 0) continue;
                        object8 = type;
                    }
                    object7 = Character.toLowerCase(string2.charAt(3)) + string2.substring(4);
                    object6 = this.instanceType.getField((String)object7);
                    if (object6 == null) {
                        object6 = this.instanceType.addField((String)object7, (Type)object8, 1);
                    }
                    Method method4 = this.instanceType.addMethod(string2, 1, typeArray, type);
                    object3 = method4.startCode();
                    ((CodeAttr)object3).emitPushThis();
                    if (c == 'g') {
                        ((CodeAttr)object3).emitGetField((Field)object6);
                    } else {
                        ((CodeAttr)object3).emitLoad(((CodeAttr)object3).getArg(1));
                        ((CodeAttr)object3).emitPutField((Field)object6);
                    }
                    ((CodeAttr)object3).emitReturn();
                    continue;
                }
                object8 = new Vector();
                ClassExp.getImplMethods(this.type, string2, typeArray, object8);
                if (((Vector)object8).size() != 1) {
                    object7 = ((Vector)object8).size() == 0 ? "missing implementation for " : "ambiguous implementation for ";
                    compilation.error('e', (String)object7 + object2);
                    continue;
                }
                object7 = this.instanceType.addMethod(string2, 1, typeArray, type);
                object3 = ((Method)object7).startCode();
                for (object6 = ((CodeAttr)object3).getCurrentScope().firstVar(); object6 != null; object6 = ((Variable)object6).nextVar()) {
                    ((CodeAttr)object3).emitLoad((Variable)object6);
                }
                object6 = (Method)((Vector)object8).elementAt(0);
                ((CodeAttr)object3).emitInvokeStatic((Method)object6);
                ((CodeAttr)object3).emitReturn();
            }
            compilation.curLambda = lambdaExp;
            ClassType classType3 = classType2;
            return classType3;
        }
        finally {
            compilation.curClass = classType;
            compilation.method = method;
        }
    }

    protected Expression walk(ExpWalker expWalker) {
        return expWalker.walkClassExp(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void walkChildren(ExpWalker expWalker) {
        LambdaExp lambdaExp = expWalker.currentLambda;
        expWalker.currentLambda = this;
        try {
            LambdaExp lambdaExp2 = this.firstChild;
            while (lambdaExp2 != null && expWalker.exitValue == null) {
                expWalker.walkLambdaExp(lambdaExp2);
                lambdaExp2 = lambdaExp2.nextSibling;
            }
        }
        finally {
            expWalker.currentLambda = lambdaExp;
        }
    }

    public void print(OutPort outPort) {
        Object object2;
        outPort.startLogicalBlock("(" + this.getExpClassName() + "/", ")", 2);
        if (this.name != null) {
            outPort.print(this.name);
            outPort.print('/');
        }
        outPort.print(this.id);
        outPort.print("/ (");
        Object var2_2 = null;
        int n = 0;
        boolean bl = false;
        int n2 = this.keywords == null ? 0 : this.keywords.length;
        int n3 = this.defaultArgs == null ? 0 : this.defaultArgs.length - n2;
        for (object2 = this.firstDecl(); object2 != null; object2 = ((Declaration)object2).nextDecl()) {
            if (n > 0) {
                outPort.print(' ');
            }
            outPort.print(object2);
            ++n;
        }
        outPort.print(") ");
        object2 = this.firstChild;
        while (object2 != null) {
            outPort.writeSpaceLinear();
            outPort.print(" method: ");
            ((LambdaExp)object2).print(outPort);
            object2 = ((LambdaExp)object2).nextSibling;
        }
        outPort.writeSpaceLinear();
        if (this.body == null) {
            outPort.print("<null body>");
        } else {
            this.body.print(outPort);
        }
        outPort.endLogicalBlock(")");
    }

    public Field compileSetField(Compilation compilation) {
        return new ClassInitializer((ClassExp)this, (Compilation)compilation).field;
    }

    public static String slotToMethodName(String string, String string2) {
        string2 = Compilation.mangleNameIfNeeded(string2);
        StringBuffer stringBuffer = new StringBuffer(string2.length() + 3);
        stringBuffer.append(string);
        stringBuffer.append(Character.toTitleCase(string2.charAt(0)));
        stringBuffer.append(string2.substring(1));
        return stringBuffer.toString();
    }
}

